<?php

// Include the NafathApiService class
include_once 'NafathApiService.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the National ID from the POST request
    $nationalId = isset($_POST['nationalId']) ? trim($_POST['nationalId']) : '';

    // Validate National ID
    if (empty($nationalId) || !is_numeric($nationalId)) {
        echo json_encode(['error' => 'Invalid National ID.']);
        exit;
    }

    // Create an instance of NafathApiService
    $nafathApiService = new NafathApiService();

    // Send MFA request and get the response
    $mfaResponse = $nafathApiService->sendMfaRequest($nationalId);

    // If successful, return transId and random value
    if (isset($mfaResponse['transId']) && isset($mfaResponse['random'])) {
        echo json_encode([
            'transId' => $mfaResponse['transId'],
            'random' => $mfaResponse['random']
        ]);
    } else {
        // Handle error if response does not contain transId or random
        echo json_encode(['error' => 'Failed to send MFA request or retrieve random value.']);
    }
}
