<?php

// Include the NafathApiService class
include_once 'NafathApiService.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the POST data
    $nationalId = isset($_POST['nationalId']) ? trim($_POST['nationalId']) : '';
    $transId = isset($_POST['transId']) ? trim($_POST['transId']) : '';
    $random = isset($_POST['random']) ? trim($_POST['random']) : '';

    // Validate input data
    if (empty($nationalId) || empty($transId) || empty($random)) {
        echo json_encode(['error' => 'Missing required parameters.']);
        exit;
    }

    // Create an instance of NafathApiService
    $nafathApiService = new NafathApiService();

    // Check MFA request status
    $statusResponse = $nafathApiService->checkMfaRequestStatus($nationalId, $transId, $random);

    // Return the response
    if (isset($statusResponse['status'])) {
        echo json_encode(['status' => $statusResponse['status']]);
    } else {
        echo json_encode(['error' => 'Error checking status.']);
    }
}
