<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>National ID Authentication</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
        }
        input, button {
            padding: 10px;
            font-size: 16px;
            margin: 10px 0;
        }
        #status {
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <h2>National ID Authentication</h2>
    
    <!-- National ID Input Form -->
    <form id="mfaForm">
        <label for="nationalId">Enter Your National ID:</label><br>
        <input type="text" id="nationalId" name="nationalId" required><br>
        <button type="submit">Submit</button>
    </form>

    <!-- Area to display results -->
    <div id="status"></div>

    <script>
        $(document).ready(function() {
            $('#mfaForm').on('submit', function(e) {
                e.preventDefault(); // Prevent form from submitting normally

                var nationalId = $('#nationalId').val();
                
                // Validate National ID (check if numeric and not empty)
                if (!nationalId || isNaN(nationalId)) {
                    $('#status').html('<p style="color:red;">Invalid National ID.</p>');
                    return;
                }

                // Clear previous status messages
                $('#status').html('<p>Processing...</p>');

                // Send AJAX request to the server
                $.ajax({
                    url: 'mfa-handler.php',  // PHP script to process the National ID
                    type: 'POST',
                    data: { nationalId: nationalId },
                    success: function(response) {
                        var data = JSON.parse(response);

                        // If response contains error or status messages
                        if (data.error) {
                            $('#status').html('<p style="color:red;">' + data.error + '</p>');
                        } else if (data.random) {
                            // Show the random value
                            $('#status').html('<p>Random value: ' + data.random + '</p>');
                            
                            // Optionally, check status here or provide a button to check status
                            $('#status').append('<button onclick="checkStatus(\'' + nationalId + '\', \'' + data.transId + '\', \'' + data.random + '\')">Check Status</button>');
                        } else {
                            $('#status').html('<p style="color:red;">Unexpected error occurred.</p>');
                        }
                    },
                    error: function() {
                        $('#status').html('<p style="color:red;">An error occurred. Please try again.</p>');
                    }
                });
            });
        });

        // Function to check status
        function checkStatus(nationalId, transId, random) {
            $('#status').html('<p>Checking status...</p>');

            $.ajax({
                url: 'mfa-status-handler.php',  // PHP script to check MFA status
                type: 'POST',
                data: {
                    nationalId: nationalId,
                    transId: transId,
                    random: random
                },
                success: function(response) {
                    var data = JSON.parse(response);

                    if (data.status === 'COMPLETED') {
                        $('#status').html('<p>Status: Authentication Completed Successfully.</p>');
                    } else if (data.status === 'WAITING') {
                        $('#status').html('<p>Status: Waiting for authentication...</p>');
                    } else {
                        $('#status').html('<p style="color:red;">Error checking status: ' + data.error + '</p>');
                    }
                },
                error: function() {
                    $('#status').html('<p style="color:red;">An error occurred while checking the status.</p>');
                }
            });
        }
    </script>
</body>
</html>
